VERSION 5.00
Begin VB.UserControl CapSeminar 
   ClientHeight    =   10515
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   13545
   ScaleHeight     =   10515
   ScaleWidth      =   13545
   Begin VB.Frame fraFilters 
      Height          =   8415
      Left            =   960
      TabIndex        =   38
      Top             =   9240
      Visible         =   0   'False
      Width           =   4215
      Begin VB.CommandButton cmd_TVReLoad 
         Height          =   735
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   39
         Tag             =   "cmd_TVReLoad"
         Top             =   720
         Width           =   735
      End
      Begin Project1.ArmCombobox cbo_Views 
         Height          =   345
         Left            =   660
         TabIndex        =   40
         Top             =   300
         Width           =   3495
         _ExtentX        =   6165
         _ExtentY        =   609
      End
      Begin Project1.ArmTreeView tvitems 
         Height          =   3915
         Left            =   120
         TabIndex        =   41
         Top             =   720
         Width           =   2805
         _ExtentX        =   4948
         _ExtentY        =   6906
      End
      Begin VB.Label lbl_view 
         Caption         =   "#View"
         Height          =   195
         Left            =   60
         TabIndex        =   42
         Tag             =   "lbl_view"
         Top             =   405
         Width           =   615
      End
   End
   Begin VB.Frame fraList 
      Height          =   4935
      Left            =   5400
      TabIndex        =   35
      Top             =   7680
      Visible         =   0   'False
      Width           =   9015
      Begin Project1.ArmGrid grList 
         Height          =   2895
         Left            =   480
         TabIndex        =   36
         Top             =   1680
         Width           =   4575
         _ExtentX        =   8070
         _ExtentY        =   5106
      End
      Begin Project1.ToolBr tbList 
         Height          =   675
         Left            =   120
         TabIndex        =   37
         Top             =   240
         Width           =   1935
         _ExtentX        =   3413
         _ExtentY        =   1191
      End
   End
   Begin VB.Frame fraItem 
      Height          =   7575
      Left            =   1440
      TabIndex        =   0
      Top             =   1560
      Visible         =   0   'False
      Width           =   10575
      Begin VB.Frame fraItemCustomers 
         Height          =   2295
         Left            =   120
         TabIndex        =   31
         Tag             =   "fraCustomers"
         Top             =   5160
         Width           =   10335
         Begin Project1.ArmGrid grCustomers 
            Height          =   1935
            Left            =   120
            TabIndex        =   32
            Tag             =   "grCustomers"
            Top             =   240
            Width           =   6975
            _ExtentX        =   12303
            _ExtentY        =   3413
         End
         Begin Project1.ToolBr tbCustomer 
            Height          =   1995
            Left            =   7200
            TabIndex        =   33
            Top             =   240
            Width           =   735
            _ExtentX        =   1296
            _ExtentY        =   3519
         End
      End
      Begin VB.Frame fraItemData 
         Height          =   4095
         Left            =   120
         TabIndex        =   1
         Top             =   960
         Width           =   10335
         Begin VB.TextBox txt_Name 
            Height          =   375
            Left            =   1800
            MaxLength       =   50
            TabIndex        =   21
            Tag             =   "txt_Name"
            Top             =   720
            Width           =   8415
         End
         Begin VB.TextBox txt_Comment 
            Height          =   1815
            Left            =   1800
            MaxLength       =   500
            MultiLine       =   -1  'True
            TabIndex        =   20
            Tag             =   "txt_Comment"
            Top             =   1200
            Width           =   4575
         End
         Begin VB.TextBox txt_TotalCount 
            Height          =   375
            Left            =   1800
            TabIndex        =   19
            Tag             =   "txt_TotalCount"
            Top             =   3600
            Width           =   975
         End
         Begin VB.TextBox txt_SMCode 
            Height          =   375
            Left            =   1800
            TabIndex        =   18
            Top             =   240
            Width           =   2895
         End
         Begin VB.Frame fraItemInfo 
            Height          =   2175
            Left            =   6480
            TabIndex        =   9
            Tag             =   "fraItemInfo"
            Top             =   1560
            Width           =   3735
            Begin VB.TextBox txt_CreatedBy 
               Height          =   375
               Left            =   1440
               TabIndex        =   13
               Tag             =   "txt_CreatedBy"
               Top             =   720
               Width           =   2175
            End
            Begin VB.TextBox txt_LastUpdatedBy 
               Height          =   375
               Left            =   1440
               TabIndex        =   12
               Tag             =   "txt_LastUpdatedBy"
               Top             =   1680
               Width           =   2175
            End
            Begin VB.TextBox txt_DateEntered 
               Height          =   375
               Left            =   1440
               TabIndex        =   11
               Tag             =   "txt_DateEntered"
               Top             =   240
               Width           =   2175
            End
            Begin VB.TextBox txt_LastUpdate 
               Height          =   375
               Left            =   1440
               TabIndex        =   10
               Tag             =   "txt_LastUpdate"
               Top             =   1200
               Width           =   2175
            End
            Begin VB.Label lbl_LastUpdated 
               Caption         =   "#Last updated"
               Height          =   255
               Left            =   120
               TabIndex        =   17
               Tag             =   "lbl_LastUpdated"
               Top             =   1320
               Width           =   1215
            End
            Begin VB.Label lbl_UpdatedBy 
               Caption         =   "#by"
               Height          =   255
               Left            =   120
               TabIndex        =   16
               Tag             =   "lbl_UpdatedBy"
               Top             =   1800
               Width           =   1215
            End
            Begin VB.Label lbl_DateEntered 
               Caption         =   "#Date entered"
               Height          =   255
               Left            =   120
               TabIndex        =   15
               Tag             =   "lbl_DateEntered"
               Top             =   360
               Width           =   1095
            End
            Begin VB.Label lbl_CreatedBy 
               Caption         =   "#by"
               Height          =   255
               Left            =   120
               TabIndex        =   14
               Tag             =   "lbl_CreatedBy"
               Top             =   840
               Width           =   1215
            End
         End
         Begin VB.TextBox txt_Spare3 
            Height          =   375
            Left            =   3840
            TabIndex        =   5
            Tag             =   "txt_Spare3"
            Top             =   3600
            Visible         =   0   'False
            Width           =   855
         End
         Begin VB.TextBox txt_spare2 
            Height          =   285
            Left            =   4920
            TabIndex        =   4
            Tag             =   "txt_spare2"
            Top             =   3720
            Visible         =   0   'False
            Width           =   735
         End
         Begin VB.TextBox txt_Spare4 
            Height          =   375
            Left            =   3360
            TabIndex        =   3
            Tag             =   "txt_Spare4"
            Top             =   3600
            Visible         =   0   'False
            Width           =   855
         End
         Begin VB.TextBox txt_Spare1 
            Height          =   495
            Left            =   5880
            TabIndex        =   2
            Tag             =   "txt_Spare1"
            Top             =   3600
            Visible         =   0   'False
            Width           =   615
         End
         Begin Project1.A_calocx cal_EndDate 
            Height          =   375
            Left            =   4560
            TabIndex        =   6
            Tag             =   "cal_EndDate"
            Top             =   3120
            Width           =   1815
            _ExtentX        =   3201
            _ExtentY        =   661
         End
         Begin Project1.A_calocx cal_StartDate 
            Height          =   375
            Left            =   1800
            TabIndex        =   7
            Tag             =   "cal_StartDate"
            Top             =   3120
            Width           =   1815
            _ExtentX        =   3201
            _ExtentY        =   661
         End
         Begin Project1.ArmCombobox cbo_Country 
            Height          =   345
            Left            =   6120
            TabIndex        =   8
            Tag             =   "cbo_Country"
            Top             =   240
            Width           =   2175
            _ExtentX        =   3836
            _ExtentY        =   609
         End
         Begin Project1.ArmCombobox cbo_Owner 
            Height          =   345
            Left            =   7560
            TabIndex        =   22
            Tag             =   "cbo_Owner"
            Top             =   1200
            Width           =   2655
            _ExtentX        =   4683
            _ExtentY        =   609
         End
         Begin VB.Label lbl_Name 
            Caption         =   "#Name"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Left            =   120
            TabIndex        =   30
            Tag             =   "lbl_Name"
            Top             =   840
            Width           =   1575
         End
         Begin VB.Label lbl_Comment 
            Caption         =   "#Comment"
            Height          =   255
            Left            =   120
            TabIndex        =   29
            Tag             =   "lbl_Comment"
            Top             =   1200
            Width           =   1575
         End
         Begin VB.Label lbl_StartDate 
            Caption         =   "#Start on"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Left            =   120
            TabIndex        =   28
            Tag             =   "lbl_StartDate"
            Top             =   3240
            Width           =   1575
         End
         Begin VB.Label lbl_Owner 
            Caption         =   "#Owner"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Left            =   6480
            TabIndex        =   27
            Tag             =   "lbl_Owner"
            Top             =   1320
            Width           =   975
         End
         Begin VB.Label lbl_TotalCount 
            Caption         =   "#Count of cust."
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Left            =   120
            TabIndex        =   26
            Tag             =   "lbl_TotalCount"
            Top             =   3720
            Width           =   1695
         End
         Begin VB.Label lbl_EndDate 
            Caption         =   "#End on"
            Height          =   375
            Left            =   3720
            TabIndex        =   25
            Tag             =   "lbl_EndDate"
            Top             =   3240
            Width           =   855
         End
         Begin VB.Label lbl_SMCode 
            Caption         =   "#Code"
            Height          =   255
            Left            =   120
            TabIndex        =   24
            Tag             =   "lbl_SMCode"
            Top             =   360
            Width           =   1575
         End
         Begin VB.Label lbl_Country 
            Caption         =   "#Country"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Left            =   4800
            TabIndex        =   23
            Tag             =   "lbl_Country"
            Top             =   360
            Width           =   1215
         End
      End
      Begin Project1.ToolBr tbItem 
         Height          =   675
         Left            =   120
         TabIndex        =   34
         Top             =   240
         Width           =   10335
         _ExtentX        =   18230
         _ExtentY        =   1191
      End
   End
End
Attribute VB_Name = "CapSeminar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private Const SEP As String = ""
Const CL_COLOR_ENABLED As Long = &H80000005
Const CL_COLOR_DISABLED As Long = &H8000000F

Const ERR_OFF As Long = 15000

Private mDb As ArmDb
Private mInitialized As Boolean
Private mLoginName As String
Private mLanguage_Code As String
Private mCst As Type_CstValues  ' Structure which contains constants value
Private mConnectionString As String 'compatibility with old toolbar

Public Event quit()

Private Const SCREEN_NAME = "Cap_Seminar"

Private Type TTreeViewInfo
    Levels As Long
    NodeRequest() As String
    GridRequest() As String
    ExcelRequest() As String
    CountRequest() As String
    FindRequest() As String
    Images() As Integer
    SelectedImages() As Integer
    TreeViewCode As String
    Loaded As Boolean
End Type
Private mTreeViewInfos() As TTreeViewInfo

Private Type TCustomer
    AC_Code As String
    CCU_CapKey As String
    CCU_Desc As String
    CCU_Town As String
    CCU_Zip As String
    CCT_Desc As String
    CNT_Code As String
    CNT_Name As String
    TIT_Desc As String
    JOB_Desc As String
    CNT_TelOffice As String
End Type

Private Type TSeminar
    SM_Code As Long
    Language_Code As String
    CT_Code As String
    CT_Desc As String
    SM_Desc As String
    SM_Comment As String
    SM_StartDate As String
    SM_EndDate As String
    
    SM_StartDate_US As String
    SM_EndDate_US As String

    Owner As String
    TotalCstCount As Integer
    NoCptCstCount As Integer
    Z_Creation As Date
    Z_Creator As String
    Z_Last_Upd As Date
    Z_Last_Upd_User As String
    SM_SP1 As String
    SM_SP2 As String
    SM_SP3 As String
    SM_SP4 As String
    iConcurrency As Integer
    Customers() As TCustomer
    
    srzCustomerToAdd As String
    srzActionDel As String
End Type
Private mSeminar As TSeminar

Private msrzCustomerToAdd As String
Private msrzActionDel As String

Private Enum eMode
    emList = 0
    emView = 1
    emAdd = 2
    emUpdate = 3
    emDelete = 4
End Enum
Private mMode As eMode
Private mOldMode As eMode
Private mTVDisable As Boolean

Private mDft_AT_Code As Long
Private mDft_AS_Code As Long
Private mDft_AR_Code As Long
Private mDft_ACT_Comment As String

Const C_AT_Code As Long = 24 ' Seminars
Const C_AS_Code As Long = 1 ' Complete
Const C_AR_Code As Long = 6 ' N/A
Const C_ACT_Comment As String = "#This action has been automatically created by the seminar functionnality"

Private p_DefaultValues(MAX_VALUE) As DefaultValue

Private Sub cal_EndDate_changeposition(Y As Integer)
    cal_EndDate.ZOrder 0
    cal_EndDate.Top = cal_EndDate.Top + Y
End Sub

Private Sub cal_startDate_changeposition(Y As Integer)
    cal_StartDate.ZOrder 0
    cal_StartDate.Top = cal_StartDate.Top + Y
End Sub

Public Property Let ConnectionString(ByVal aValue As String)
    mConnectionString = aValue
End Property

Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property

Public Property Let Top(ByVal aTop As Single)
    UserControl.Extender.Top = aTop
    If mInitialized Then Call Resize
End Property
Public Property Get Top() As Single
    Top = UserControl.Extender.Top
End Property

Public Property Let Height(ByVal aHeight As Single)
    UserControl.Extender.Height = aHeight
    If mInitialized Then Call Resize
End Property
Public Property Get Height() As Single
    Height = UserControl.Extender.Height
End Property

Public Property Let Left(ByVal aLeft As Single)
    UserControl.Extender.Left = aLeft
    If mInitialized Then Call Resize
End Property
Public Property Get Left() As Single
    Left = UserControl.Extender.Left
End Property

Public Property Let Width(ByVal aWidth As Single)
    UserControl.Extender.Width = aWidth
    If mInitialized Then Call Resize
End Property
Public Property Get Width() As Single
    Width = UserControl.Extender.Width
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
    If mInitialized Then Call Resize
End Sub

Public Property Set Db(ByRef aDb As ArmDb)
    Set mDb = aDb
End Property
Public Property Get Initialized() As Boolean
    Initialized = mInitialized
End Property
Public Property Let Login(ByVal aValue As String)
    mLoginName = aValue
End Property
Public Property Let Language_Code(ByVal aValue As String)
    mLanguage_Code = aValue
End Property
Public Property Set Cst(ByRef aValue As Type_CstValues)
    Set mCst = aValue
End Property


Public Function Load_A_Com() As Boolean
    
    On Error GoTo Trace_Err
    
    Dim lIdx As Long, lCount As Long
    ReDim mSeminar.Customers(-1 To -1)
    
    Call LoadLabels(UserControl.Controls, SCREEN_NAME, mLanguage_Code)
    Call ChangeCharset(UserControl.Controls, GetCodePageFromLanguage(mDb, mLanguage_Code))
    
    mDft_AT_Code = C_AT_Code
    mDft_AS_Code = C_AS_Code
    mDft_AR_Code = C_AR_Code
    mDft_ACT_Comment = C_ACT_Comment
    lCount = GetScreenDefaultValues(mDb, mLoginName, mLanguage_Code, SCREEN_NAME, p_DefaultValues)
    For lIdx = 0 To lCount - 1
        Select Case p_DefaultValues(lIdx).FieldName
            Case "ActionType"
                mDft_AT_Code = p_DefaultValues(lIdx).CodeValue
            Case "ActionStatus"
                mDft_AS_Code = p_DefaultValues(lIdx).CodeValue
            Case "ActionReason"
                mDft_AR_Code = p_DefaultValues(lIdx).CodeValue
            Case "ActionComment"
                mDft_ACT_Comment = p_DefaultValues(lIdx).DescValue
        End Select
    Next
    
    Set cbo_country.ArmDb = mDb
    cbo_country.Load_A_Com
    cbo_country.FirstBlankItem = False
    cbo_country.Request = "exec countries_cbo6 " & "'" & mLanguage_Code & "'"
    
    Set cbo_Owner.ArmDb = mDb
    cbo_Owner.Load_A_Com
    cbo_Owner.FirstBlankItem = False
    cbo_Owner.Request = "exec cap_actionraisedfor_cbo"
    
    cal_StartDate.Language = mLanguage_Code
    cal_EndDate.Language = mLanguage_Code
    cal_StartDate.opening_toward_top = 1
    cal_EndDate.opening_toward_top = 1
    
    ' Initialize the toolbar
    Set tbList.ArmDb = mDb
    tbList.Language = mLanguage_Code
    tbList.ConnectString = mConnectionString
    tbList.Load_A_Com
    tbList.ClearAllIcons
    tbList.TableName = "Cap_Seminars"
    tbList.PictureDisplayed = "P_Refresh=7 P_Execute=6 P_Quit=-1"
    tbList.DrivenByCapture = True
    tbList.Refresh
    
    Set tbCustomer.ArmDb = mDb
    tbCustomer.Language = mLanguage_Code
    tbCustomer.ConnectString = mConnectionString
    tbCustomer.Load_A_Com
    tbCustomer.ClearAllIcons
    tbCustomer.PictureDisplayed = "P_Add=1 P_Delete=2"
    
    Set tbItem.ArmDb = mDb
    tbItem.Language = mLanguage_Code
    tbItem.ConnectString = mConnectionString
    tbItem.Load_A_Com
    tbItem.ClearAllIcons

    ' Initialize the treeview
    Set tvitems.ArmDb = mDb
    tvitems.Language = mLanguage_Code
    tvitems.AllowCheckboxes = True
    tvitems.UseImages = False
    tvitems.Load_A_Com

    ' Initialize the grid
    Set grList.ArmDb = mDb
    grList.Load_A_Com
    grList.AllowExcelExport = True
    grList.ExportTitles = True
    grList.MultiSelect = False
    
    Dim lColumns As Variant
    ReDim lColumns(5)
    lColumns(0) = Join(Array("SM_Code", 0, 1, "SM_Code", lbl_SMCode.Caption), SEP)
    lColumns(1) = Join(Array("SM_Desc", 2000, 0, "SM_Desc", Lbl_name.Caption), SEP)
    lColumns(2) = Join(Array("CT_Desc", 1200, 0, "CT_Desc", lbl_Country.Caption), SEP)
    lColumns(3) = Join(Array("Owner", 1500, 0, "Owner", lbl_Owner.Caption), SEP)
    lColumns(4) = Join(Array("SM_StartDate", 1000, 0, "SM_StartDate", lbl_StartDate.Caption), SEP)
    lColumns(5) = Join(Array("SM_EndDate", 1000, 0, "SM_EndDate", lbl_EndDate.Caption), SEP)
    If Not grList.SetColumns(lColumns) Then
        GoTo Trace_Err
        'debug.print "grList.SetColumns error"
        Exit Function
    End If

    Set grCustomers.ArmDb = mDb
    grCustomers.Load_A_Com
    grCustomers.AllowExcelExport = True
    grCustomers.ExportTitles = True
    grCustomers.MultiSelect = True
    grCustomers.UnBound = True

    ReDim lColumns(10)
    lColumns(0) = Join(Array("CCU_CAPKEY", 0, 1, "CCU_Capkey", "#CCU_Capkey"), SEP)
    lColumns(1) = Join(Array("CNT_CODE", 0, 2, "CNT_CODE", "#CNT_CODE"), SEP)
    lColumns(2) = Join(Array("AC_Code", 0, 0, "AC_Code", "#AC_Code"), SEP)
    lColumns(3) = Join(Array("CCU_Desc", 2000, 0, "CCU_Desc", "#CCU_Name"), SEP)
    lColumns(4) = Join(Array("CCU_Town", 2000, 0, "CCU_Town", "#CCU_Town"), SEP)
    lColumns(5) = Join(Array("CCU_Zip", 1500, 0, "CCU_Zip", "#CCU_Zip"), SEP)
    lColumns(6) = Join(Array("CCT_Desc", 1500, 0, "CCT_Desc", "#CCT_Desc"), SEP)
    
    lColumns(7) = Join(Array("TIT_desc", 1500, 0, "TIT_desc", "#TIT_desc"), SEP)
    lColumns(8) = Join(Array("CNT_LastName", 1500, 0, "CNT_LastName", "#CNT_LastName"), SEP)
    
    lColumns(9) = Join(Array("JOB_Desc", 1500, 0, "JOB_Desc", "#JOB_Desc"), SEP)
    lColumns(10) = Join(Array("CNT_telOffice", 1500, 0, "CNT_telOffice", "#CNT_telOffice"), SEP)
    
    If Not grCustomers.SetColumns(lColumns) Then
        'debug.print "grCustomers.SetColumns error"
        Exit Function
    End If

    ' Initializing the view combo
    Set cbo_Views.ArmDb = mDb
    Call cbo_Views.Load_A_Com
    Call cbo_Views.Clear
    cbo_Views.FirstBlankItem = False
    cbo_Views.Request = "exec TreeView_View_t_lst '" & SCREEN_NAME & "'," & "'" & mLanguage_Code & "'"
    cbo_Views.Load
    If cbo_Views.Count = 0 Then
        'debug.print "No views"
        Exit Function
    End If
    lCount = cbo_Views.Count - 1
    If lCount > -1 Then
        ReDim mTreeViewInfos(lCount)
    Else
        ReDim mTreeViewInfos(-1 To -1)
    End If
    For lIdx = 0 To lCount
        mTreeViewInfos(lIdx).Loaded = False
        mTreeViewInfos(lIdx).TreeViewCode = cbo_Views.ComboItems(lIdx + 1).Key
    Next
    cbo_Views.SearchItem "X", "TV_Default", 0

    cmd_TVReLoad.Visible = False
    cmd_TVReLoad.Picture = LoadResPicture(61, vbResIcon)

    Call Resize
    
    fraFilters.Visible = True
    fraList.Visible = True
    
    mInitialized = True
    Load_A_Com = True
    
Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Load_A_com"
    
End Function

Public Function Unload_A_Com() As Boolean
    
On Error GoTo Trace_Err

    tbList.Unload_A_Com
    tbItem.Unload_A_Com
    grList.Unload_A_Com

    
    cbo_country.Unload_A_Com
    cbo_Owner.Unload_A_Com
    
    cbo_Views.Unload_A_Com
    tvitems.Unload_A_Com
    tbList.Unload_A_Com
    
    Set mDb = Nothing
    Set mCst = Nothing
    
    Unload_A_Com = True
    
Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Unload_A_COM"

    
End Function

Private Sub Resize()

On Error GoTo Trace_Err

    Dim lLeft As Long, lTop As Long, lWidth As Long, lHeight As Long
    
    lLeft = 120
    lTop = 120
    lWidth = 4215
    lHeight = UserControl.Height - 120 - lTop
    
    Call fraFilters.Move(lLeft, lTop, lWidth, lHeight)
    
    lLeft = 660
    lTop = 300
    lWidth = fraFilters.Width - lLeft - 120
    lHeight = 345
    Call cbo_Views.Move(lLeft, lTop, lWidth, lHeight)
    
    lLeft = 120
    lTop = cbo_Views.Top + cbo_Views.Height + 120
    lWidth = fraFilters.Width - lLeft - 120
    lHeight = fraFilters.Height - 120 - lTop
    Call tvitems.Move(lLeft, lTop, lWidth, lHeight)
    Call cmd_TVReLoad.Move(lLeft, lTop)
    
    lLeft = fraFilters.Left + fraFilters.Width + 120
    lTop = 120
    lWidth = UserControl.Width - lLeft - 120
    lHeight = UserControl.Height - lTop - 120
    Call fraList.Move(lLeft, lTop, lWidth, lHeight)
    
    lLeft = 120
    lTop = 240
    lWidth = fraList.Width - 120 - lLeft
    lHeight = 675
    Call tbList.Move(lLeft, lTop, lWidth, lHeight)
    tbList.Refresh
    Call tbItem.Move(lLeft, lTop, lWidth, lHeight)
    tbItem.Refresh
    
    lLeft = 120
    lTop = tbList.Top + tbList.Height + 120
    lWidth = fraList.Width - 120 - lLeft
    lHeight = fraList.Height - 120 - lTop
    Call grList.Move(lLeft, lTop, lWidth, lHeight)

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Resize"
    
End Sub


Private Sub cbo_Views_ComboItemSelected()

On Error GoTo Trace_Err

    If Not cbo_Views.SelectedItem Is Nothing Then
        Call LoadTreeView(tvitems, GetTreeViewInfo(mTreeViewInfos, SCREEN_NAME, cbo_Views.SelectedItem.Key), grList)
    End If

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":cbo_Views_ComboItemSelected"
    
End Sub

Private Function GetTreeViewInfo(ByRef aTVInfos() As TTreeViewInfo, ByVal AScreenName As String, ByVal aTVCode As String) As TTreeViewInfo
    
    On Error GoTo Trace_Err
    
    Dim lIdx As Long, lCount As Long
    Dim lTreeView As TTreeViewInfo, lFound As Boolean
    
    ' Search in the array
    lCount = UBound(aTVInfos)
    lFound = False
    For lIdx = 0 To lCount
        If aTVInfos(lIdx).TreeViewCode = aTVCode Then
            aTVInfos(lIdx).Loaded = False
            If Not aTVInfos(lIdx).Loaded Then
                aTVInfos(lIdx) = GetTreeViewInfoFromDB(AScreenName, aTVCode)
            End If
            lTreeView = aTVInfos(lIdx)
            lFound = True
            Exit For
        End If
    Next
    
    If Not lFound Then
        'ERROR
    End If
    
    GetTreeViewInfo = lTreeView
    
Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":GetTreeViewInfo"
    
End Function



Private Function LoadTreeView(ByRef aTV As ArmTreeView, ByRef aTreeViewInfo As TTreeViewInfo, Optional ByRef aGrid As ArmGrid = Nothing) As Boolean

On Error GoTo Trace_Err

    aTV.Clear
    ' Clearing the associated grid
    If Not aGrid Is Nothing Then
        aGrid.Requests = ""
        Call aGrid.ClearGrid
    End If

    aTV.Levels = aTreeViewInfo.Levels
    aTV.StartDemandLevel = 1
    aTV.SelectedImages = aTreeViewInfo.SelectedImages
    aTV.Images = aTreeViewInfo.Images
    aTV.NodeRequests = ApplyTVFilters(aTreeViewInfo.NodeRequest)
    aTV.GridRequests = aTreeViewInfo.GridRequest
    aTV.FindRequests = ApplyTVFilters(aTreeViewInfo.FindRequest)
    aTV.CountRequests = aTreeViewInfo.CountRequest
    
    LoadTreeView = aTV.LoadTree(LoadTypeChildsDemand)
Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":LoadTreeView"
    
    
End Function



Private Function GetTreeViewInfoFromDB(ByVal AScreenName As String, ByVal aTVCode As String) As TTreeViewInfo

On Error GoTo Trace_Err

    Dim lTreeView As TTreeViewInfo
    Dim lRequest As String
    Dim lCurs As Long, lIdx As Long, lCount As Long
    
    ' Get the data from the DB
    lRequest = "EXEC Treeview_Parameters_lst '" & AScreenName & "', '" & aTVCode & "'"
    lCurs = mDb.OpenSQL(lRequest)
    If lCurs = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:GetTreeViewInfoFromDB", "Requests=", lRequest
        GoTo Trace_End
    End If
    
    lCount = mDb.RowCount(lCurs) - 1
    
    If lCount = -1 Then
        'debug.print "ERROR GetTreeViewInfoFromDB"
    End If
    
    ReDim lTreeView.NodeRequest(lCount)
    ReDim lTreeView.GridRequest(lCount)
    ReDim lTreeView.ExcelRequest(lCount)
    ReDim lTreeView.FindRequest(lCount)
    ReDim lTreeView.CountRequest(lCount)
    ReDim lTreeView.Images(lCount)
    ReDim lTreeView.SelectedImages(lCount)
    
    Dim lLevel As Long
    For lIdx = 0 To lCount
        lLevel = mDb.GetFields(lCurs, "TV_Level")
        lTreeView.NodeRequest(lLevel) = ReplaceCommonHolders(mDb.GetFields(lCurs, "TV_NodeRequest"))
        lTreeView.GridRequest(lLevel) = ReplaceCommonHolders(mDb.GetFields(lCurs, "TV_GridRequest"))
        lTreeView.ExcelRequest(lLevel) = ReplaceCommonHolders(mDb.GetFields(lCurs, "TV_ExcelRequest"))
        lTreeView.FindRequest(lLevel) = ReplaceCommonHolders(mDb.GetFields(lCurs, "TV_FindRequest"))
        lTreeView.CountRequest(lLevel) = ReplaceCommonHolders(mDb.GetFields(lCurs, "TV_CountRequest"))
        lTreeView.Images(lLevel) = mDb.GetFields(lCurs, "TV_Images")
        lTreeView.SelectedImages(lLevel) = mDb.GetFields(lCurs, "TV_SelectedImages")
        mDb.Next (lCurs)
    Next
    
    lTreeView.TreeViewCode = aTVCode
    lTreeView.Levels = lCount + 1
    lTreeView.Loaded = True
    GetTreeViewInfoFromDB = lTreeView
    
    mDb.Close (lCurs)
    
Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":GetTreeViewInfoFromDB"
    
End Function


Private Function ApplyTVFilters(ByVal aRequest As Variant) As Variant

On Error GoTo Trace_Err
    
    Dim lRequests As Variant
    If IsArray(aRequest) Then
        ReDim lRequests(UBound(aRequest))
        Dim lIdx As Long, lCount As Long
        lCount = UBound(lRequests)
        For lIdx = 0 To lCount
            lRequests(lIdx) = ReplaceTVFiltersHolders(aRequest(lIdx))
        Next
    Else
        ReDim lRequests(0)
        lRequests(0) = ReplaceTVFiltersHolders(aRequest)
    End If

    ApplyTVFilters = lRequests
Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":ApplyTVFilters"
    
    
End Function


Private Function ReplaceTVFiltersHolders(ByVal aRequest As String) As String

On Error GoTo Trace_Err

    Dim lRequest As String
    lRequest = aRequest
    
    ' TODO : add here if there is some filters applied on the treeview
    
    ReplaceTVFiltersHolders = lRequest

Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":ReplaceTVFiltersHolders"

End Function



Private Sub EnableFrame(ByRef aControls As Variant, ByRef aContainer As Object, ByVal aEnabled As Boolean)

On Error GoTo Trace_Err

    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        If HasContainer(lControl, aContainer) Then
            Select Case UCase(TypeName(lControl))
                Case "FRAME", "LABEL", "MSFLEXGRID", "TOOLBARCONTROL", "TOOLBR"
                    ' Do nothing !
                Case "TEXTBOX"
                    Call EnableTextBox(lControl, aEnabled)
                Case "ARMGRID", "ARMCHECKVIEW"
                Case "COMMANDBUTTON", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "SPINBUTTON"
                    lControl.Enabled = aEnabled
                Case Else
                    lControl.Enabled = aEnabled
                    'debug.print "EnableFrame " & UCase(TypeName(lControl))
            End Select
        End If
        Set lControl = Nothing
    Next

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":EnableFrame"

End Sub


Private Sub EnableTextBox(ByVal aTextBox As TextBox, ByVal aEnabled As Boolean)

On Error GoTo Trace_Err

    aTextBox.Locked = Not aEnabled
    aTextBox.BackColor = IIf(aEnabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
    
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":EnableTextBox"
    
End Sub


' Apply default value on a screen
Private Sub ClearForm(ByRef aControls As Variant, ByRef aContainer As Object)
    
On Error GoTo Trace_Err

    Dim lIdx As Long, lCount As Long, lControl As Object
    lCount = aControls.Count - 1
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        If HasContainer(lControl, aContainer) Then
            Select Case UCase(TypeName(lControl))
                Case "TEXTBOX"
                    lControl.Text = ""
                Case "ARMCOMBOBOX"
                    Set lControl.SelectedItem = Nothing
                Case "A_CALOCX"
                    lControl.reinit_cal
                Case "CHECKBOX"
                    lControl.value = False
                Case "ARMCHECKVIEW"
                    'lControl.Reset
                Case "FRAME", "LABEL", "TOOLBARCONTROL", "PICTUREBOX", "COMMANDBUTTON", "TOOLBR"
                    ' DO NOTHING
                Case "ARMGRID"
                    lControl.ClearGrid
                Case "LISTBOX"
                    lControl.ListIndex = -1
                Case Else
                    'debug.print "ClearForm " & UCase(TypeName(lControl))
            End Select
        End If
        
        Set lControl = Nothing
    Next
Trace_End:
    Exit Sub
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":ClearForm"

End Sub

Private Function HasContainer(ByRef aControl As Control, ByRef aContainer As Object) As Boolean
    
    HasContainer = False
    Dim lControl As Control
    
    Set lControl = aControl
    While Not (lControl Is Nothing)
        On Error GoTo NotFound
        If lControl.Container Is aContainer Then
            Set lControl = Nothing
            HasContainer = True
            Exit Function
        End If
        Set lControl = lControl.Container
    Wend

NotFound:
    Set lControl = Nothing
    HasContainer = False
End Function

Private Sub SetMode(ByVal aMode As eMode)
    mOldMode = mMode
    mMode = aMode
End Sub


Private Sub Item_AddClear()

On Error GoTo Trace_Err
    
    Call ClearForm(UserControl.Controls, fraItem)
    txt_DateEntered.Text = Date
    txt_LastUpdate.Text = Date
    txt_CreatedBy.Text = mLoginName
    txt_LastUpdatedBy.Text = mLoginName
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_AddClear"
  
End Sub



Private Sub Item_ExitToGrid()

On Error GoTo Trace_Err

    SetMode (emList)
    fraItem.Visible = False
    Call EnableFrame(UserControl.Controls, fraFilters, True)
    Call EnableFrame(UserControl.Controls, fraList, True)
    fraList.Visible = True
    fraFilters.Visible = True
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_ExitToGrid"

End Sub


Public Function Item_Check() As Boolean

On Error GoTo Trace_Err

    If cbo_country.SelectedItem Is Nothing Then
        Call SendFieldErrMsg(966, lbl_Country.Caption, cbo_country)
        Exit Function
    End If
    If Len(Txt_name.Text) = 0 Then
        Call SendFieldErrMsg(966, lbl_Country.Caption, Txt_name)
        Exit Function
    End If
    If cbo_Owner.SelectedItem Is Nothing Then
        Call SendFieldErrMsg(966, lbl_Owner.Caption, cbo_Owner)
        Exit Function
    End If
    
    If cal_StartDate.date_courte = "" Then
        Call SendFieldErrMsg(966, lbl_StartDate.Caption, cal_StartDate)
        Exit Function
    End If
    
    If cal_EndDate.date_courte <> "" Then
        If cal_StartDate.date_sql > cal_EndDate.date_sql Then
            Call SendMessage(1118, "End date cannot be greater than start date !", mLanguage_Code)
            Exit Function
        End If
    End If
    
    If Len(txt_TotalCount.Text) = 0 Then
        Call SendFieldErrMsg(966, lbl_TotalCount.Caption, txt_TotalCount)
        Exit Function
    End If
    
    If (Not isNumeric(txt_TotalCount.Text)) Or (InStr(1, txt_TotalCount.Text, ".", vbTextCompare) > 0) Or (InStr(1, txt_TotalCount.Text, ",", vbTextCompare) > 0) Then
        Call SendMessage(1115, "Only numeric value allowed", mLanguage_Code)
        txt_TotalCount.SetFocus
        txt_TotalCount.SelStart = 0
        txt_TotalCount.SelLength = Len(txt_TotalCount.Text)
        Exit Function
    End If
    
    If Val(txt_TotalCount.Text) = 0 Then
        Call SendMessage(1116, "At least one customer is needed for a customer", mLanguage_Code)
        txt_TotalCount.SetFocus
        txt_TotalCount.SelStart = 0
        txt_TotalCount.SelLength = Len(txt_TotalCount.Text)
        Exit Function
    End If
    
    
    If Val(txt_TotalCount.Text) < grCustomers.Rows Then
        Call SendMessage(1117, "There is more customers specified than total customers ", mLanguage_Code)
        txt_TotalCount.SetFocus
        txt_TotalCount.SelStart = 0
        txt_TotalCount.SelLength = Len(txt_TotalCount.Text)
        Exit Function
    End If
    
    Item_Check = True
    
Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_Check"

End Function


Private Function GetNextKey(ByVal as_TableName, ByRef al_Key As Long, Optional ByVal al_TryCount As Integer = 5) As Boolean

    On Error GoTo onError
    
    
    Dim ls_Request As String

    ls_Request = "SELECT Table_Key" & vbCrLf & _
                 "FROM SYS_TablesKeys" & vbCrLf & _
                 "WHERE Table_Name = '" & as_TableName & "'"

    ' STEP 1 - Read the current key
    Dim lc_Cursor As Long, ll_CurrentKey As Long, ll_NewKey As Long
    
      
    lc_Cursor = mDb.OpenSQL(ls_Request)
    If mDb.RowCount(lc_Cursor) = 0 Then
        'Err.Raise C_ERR_OFFSET + C_ERR_DB_FAULT, mDb.LastErrorCode & " : " & mDb.LastErrorMessage & ", " & vbCrLf & "Error in GetNextKey, #1", C_ERR_DB_FAULT_MSG
    End If

    ' STEP 2 - Calculate the new
    ll_CurrentKey = mDb.GetFields(lc_Cursor, 0)
    mDb.Close (lc_Cursor)
    ll_NewKey = ll_CurrentKey + 1
    
    
    ' STEP 3 - Try to register the new key
    ls_Request = "UPDATE SYS_TablesKeys" & vbCrLf & _
                 "SET Table_Key = " & ll_NewKey & vbCrLf & _
                 "WHERE Table_Name = '" & as_TableName & "' " & _
                 "AND Table_Key = " & ll_CurrentKey & vbCrLf

    If Not mDb.ExecuteSQL(ls_Request) Then
      'Err.Raise C_ERR_OFFSET + C_ERR_DB_FAULT, mDb.LastErrorCode & " : " & mDb.LastErrorMessage & ", " & vbCrLf & "Error in GetNextKey, #2", C_ERR_DB_FAULT_MSG
    End If

    If mDb.SQLRowsAffected = 1 Then
        ' That's all folks !
        al_Key = ll_NewKey
        GetNextKey = True
    Else
        ' No luck, try again !
        If al_TryCount = 0 Then ' Too much tries, server should busy...
            GetNextKey = False
        Else
            GetNextKey = GetNextKey(as_TableName, al_Key, al_TryCount - 1)
        End If
    End If

    Exit Function

onError:
    mDb.Close (lc_Cursor)
    GetNextKey = False

End Function

Private Sub SendFieldErrMsg(ByVal aMsgID As Long, ByVal aCaption As String, ByRef AField As Object)

    Dim lBuffer As String
    Dim lMsgID As Long
    lMsgID = aMsgID ' @!#'@@ of byref argument !
    lBuffer = MsgText(lMsgID, mLanguage_Code, "#This field is not entered correctly : ")
    lBuffer = Replace(lBuffer, "$field$", aCaption)
    
    AField.SetFocus
    Call MsgBox(lBuffer, vbOKOnly + vbCritical)

End Sub

Private Sub Item_Add()
    
On Error GoTo Trace_Err
    
    If Not Item_Check Then Exit Sub

    Dim lSeminar As TSeminar
    
    If Not FormToLocal(lSeminar) Then
        Call SendMessage(1119, "Unable to fill the form", mLanguage_Code)
        Exit Sub
    End If
    
    'LocalTODB
    If Not Item_DbAdd(lSeminar) Then
        Call SendMessage(1120, "Unable to add the data to the database", mLanguage_Code)
        Exit Sub
    End If

    mSeminar = lSeminar
    
    Call Item_AddLocal
    Call Item_ExitToGrid
    
    Exit Sub

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_Add"

End Sub


Private Function FormToLocal(ByRef aSeminar As TSeminar) As Boolean
    
On Error GoTo Trace_Err

    aSeminar.CT_Code = cbo_country.SelectedItem.Key
    aSeminar.CT_Desc = cbo_country.SelectedItem.DisplayText
    
    aSeminar.SM_Desc = Txt_name.Text
    aSeminar.SM_Comment = txt_comment.Text
    
    aSeminar.Owner = cbo_Owner.SelectedItem.Key
    
    aSeminar.SM_EndDate = cal_EndDate.date_courte
    aSeminar.SM_StartDate = cal_StartDate.date_courte
    
    aSeminar.SM_EndDate_US = cal_EndDate.date_us
    aSeminar.SM_StartDate_US = cal_StartDate.date_us
    
    aSeminar.SM_SP1 = txt_spare1.Text
    aSeminar.SM_SP2 = txt_spare2.Text
    aSeminar.SM_SP3 = txt_spare3.Text
    aSeminar.SM_SP4 = txt_spare4.Text
    
    aSeminar.TotalCstCount = txt_TotalCount.Text
    
    Dim lIdx As Long, lCount As Long
    lCount = grCustomers.Rows - 1
    If lCount = -1 Then
        ReDim aSeminar.Customers(-1 To -1)
        aSeminar.NoCptCstCount = aSeminar.TotalCstCount
    Else
        aSeminar.NoCptCstCount = aSeminar.TotalCstCount - lCount - 1
        ReDim aSeminar.Customers(lCount)
        For lIdx = 0 To lCount
            aSeminar.Customers(lIdx).CCU_CapKey = grCustomers.Data(lIdx, "CCU_Capkey")
            aSeminar.Customers(lIdx).CCT_Desc = grCustomers.Data(lIdx, "CCT_Desc")
            aSeminar.Customers(lIdx).CCU_Desc = grCustomers.Data(lIdx, "CCU_Desc")
            aSeminar.Customers(lIdx).CCU_Town = grCustomers.Data(lIdx, "CCU_Town")
            aSeminar.Customers(lIdx).CCU_Zip = grCustomers.Data(lIdx, "CCU_Zip")
            aSeminar.Customers(lIdx).CNT_Code = grCustomers.Data(lIdx, "CNT_Code")
            aSeminar.Customers(lIdx).CNT_Name = grCustomers.Data(lIdx, "CNT_LastName")
            aSeminar.Customers(lIdx).CNT_TelOffice = grCustomers.Data(lIdx, "CNT_TelOffice")
            aSeminar.Customers(lIdx).JOB_Desc = grCustomers.Data(lIdx, "JOB_Desc")
            aSeminar.Customers(lIdx).TIT_Desc = grCustomers.Data(lIdx, "TIT_Desc")
        Next
    End If
    
    aSeminar.srzActionDel = msrzActionDel
    aSeminar.srzCustomerToAdd = msrzCustomerToAdd
    
    FormToLocal = True

Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":FormToLocal"
    FormToLocal = False

End Function


Private Function ReplaceCommonHolders(ByVal aRequest As String) As String
    
On Error GoTo Trace_Err

    Dim lBuffer As String
    lBuffer = Replace(aRequest, "$language_code$", mLanguage_Code, , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$login$", mLoginName, , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$Z_Creator$", mLoginName, , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$Z_Last_Upd_User$", mLoginName, , , vbTextCompare)
    lBuffer = Replace(lBuffer, "'$Z_Creation$'", "GetDate()", , , vbTextCompare)
    lBuffer = Replace(lBuffer, "'$Z_Last_Upd$'", "GetDate()", , , vbTextCompare)
    ReplaceCommonHolders = lBuffer

Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":ReplaceCommonHolders"
    
    
End Function

Private Function ReplaceHoldersFromLocal(ByVal aRequest As String, ByRef aSeminar As TSeminar) As String
    
On Error GoTo Trace_Err

    Dim lBuffer As String
    lBuffer = aRequest
    
    lBuffer = Replace(lBuffer, "$sm_code$", aSeminar.SM_Code, , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$ct_code$", aSeminar.CT_Code, , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$sm_desc$", Replace(aSeminar.SM_Desc, "'", "''", , , vbTextCompare), , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$sm_comment$", Replace(aSeminar.SM_Comment, "'", "''", , , vbTextCompare), , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$sm_startdate$", aSeminar.SM_StartDate_US, , , vbTextCompare)
    If aSeminar.SM_EndDate_US <> "" Then
        lBuffer = Replace(lBuffer, "$sm_enddate$", aSeminar.SM_EndDate_US, , , vbTextCompare)
    Else
        lBuffer = Replace(lBuffer, "'$sm_enddate$'", "NULL", , , vbTextCompare)
    End If
    lBuffer = Replace(lBuffer, "$owner$", Replace(aSeminar.Owner, "'", "''", , , vbTextCompare), , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$totalcstcount$", aSeminar.TotalCstCount, , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$nocptcstcount$", aSeminar.NoCptCstCount, , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$sm_sp1$", Replace(aSeminar.SM_SP1, "'", "''", , , vbTextCompare), , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$sm_sp2$", Replace(aSeminar.SM_SP2, "'", "''", , , vbTextCompare), , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$sm_sp3$", Replace(aSeminar.SM_SP3, "'", "''", , , vbTextCompare), , , vbTextCompare)
    lBuffer = Replace(lBuffer, "$sm_sp4$", Replace(aSeminar.SM_SP4, "'", "''", , , vbTextCompare), , , vbTextCompare)
        
    lBuffer = Replace(lBuffer, "$iconcurrency$", aSeminar.iConcurrency, , , vbTextCompare)
    
    ReplaceHoldersFromLocal = lBuffer

Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":ReplaceHoldersFromLocal"
    
End Function


Private Sub tbList_action(ByVal as_ActionType As String)
On Error GoTo Trace_Err

    Select Case UCase$(as_ActionType)
        Case "ADD"
            Call Item_AddInit
        Case "UPDATE"
            If grList.SelectedCount > 0 Then
                Call Item_Load(grList.CurrentKey(0), emUpdate)
            End If
        Case "DELETE"
            If grList.SelectedCount > 0 Then
                Call Item_Load(grList.CurrentKey(0), emDelete)
            End If
        Case "REFRESH"
            Call RefreshList
        Case "EXECUTE"
            Call LoadCurrentTVSelection
        Case "QUIT"
            RaiseEvent quit
    End Select

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":tbList_action"

End Sub

Private Sub tvitems_CheckboxesChange(Checkboxes As Boolean)
On Error GoTo Trace_Err
    grList.Requests = ""
    grList.ClearGrid
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":tvitems_CheckboxesChange"

End Sub

Private Sub tvItems_NodeClick(ByVal Node As MSComctlLib.Node)
    
On Error GoTo Trace_Err

    If mTVDisable Then Exit Sub

    Screen.MousePointer = vbHourglass
    ' Clear the grids
    grList.Requests = ""
    Call grList.ClearGrid

    If tvitems.Checkboxes Then
        Screen.MousePointer = 0
        Exit Sub
    End If

    ' If the selected node is on the last level, we have to load the grids
    If tvitems.NodeInfo(Node).ml_Level = tvitems.Levels - 1 Then
        grList.Requests = ApplyTVFilters(tvitems.SelectedNodeRequest)
        If grList.Execute = False Then
            'ERROR
        End If
    End If

    Screen.MousePointer = vbDefault
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":tvItems_NodeClick"


End Sub

Private Sub OnFilterChange()

On Error GoTo Trace_Err

    'Dim lFilters As String
    'grList.Title = lFilters
    
    If Not mInitialized Then Exit Sub
    
    tvitems.Visible = False
    tvitems.Clear
    cmd_TVReLoad.Visible = True
        
    grList.Requests = ""
    grList.ClearGrid
    
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":OnFilterChange"
    
End Sub

Private Sub RefreshList()
On Error GoTo Trace_Err

    tvitems.Refresh
    If tvitems.Checkboxes = True Or grList.Row > 0 Then
        Call LoadCurrentTVSelection
    End If
    
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":RefreshList"

End Sub

Private Sub LoadCurrentTVSelection()

On Error GoTo Trace_Err

    If tvitems.Checkboxes = True Then
        grList.Requests = ApplyTVFilters(tvitems.CheckedNodesRequests)
    Else
        grList.Requests = ApplyTVFilters(tvitems.SelectedNodeRequest)
    End If
    If grList.Execute = False Then
        'Error
    End If
    
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":LoadCurrentTVSelection"
    
End Sub



Private Sub Item_AddLocal()

On Error GoTo Trace_Err

    Dim lPath As String
    lPath = GetCurrentPath(UserControl.Controls, fraItem, cbo_Views.SelectedItem.GetData(2))
    
    If FindInTreeView(tvitems, lPath) Then
       ' FOR NEXT TIME Item has been created, we can here write a network optimisation if we know what to put in the grid
        grList.Requests = ApplyTVFilters(tvitems.SelectedNodeRequest)
        If grList.Execute = False Then Debug.Print "unable to load the grid"
    Else
         grList.Requests = ApplyTVFilters(tvitems.SelectedNodeRequest)
        If grList.Execute = False Then Debug.Print "unable to load the grid"
    End If
    
    If Not grList.SearchKey(True, Array(mSeminar.SM_Code)) Then
        ' ERROR
        'debug.print "unable to find the item"
    End If
    
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then Call go_Trace.WriteTraceError(Err.Number, Err.Description, SCREEN_NAME & ":Item_AddLocal")

End Sub


Private Function GetCurrentPath(ByRef aControls As Variant, ByRef aContainer As Object, ByVal aPattern As String) As String

On Error GoTo Trace_Err

    Dim lPattern() As String
    lPattern = Split(aPattern, SEP)

    Dim lPath() As String
    lPath = lPattern

    Dim lIdxPattern As Long, lCountPattern As Long, lIdxPath As Long
    Dim lIdx As Long, lCount As Long, lIdxLbl As Long
    Dim lControl As Control

    lCountPattern = UBound(lPattern)
    lCount = aControls.Count - 1
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        If HasContainer(lControl, aContainer) Then
            lIdxPath = -1
            For lIdxPattern = 0 To lCountPattern
                If StrComp(lControl.Tag, lPattern(lIdxPattern), vbTextCompare) = 0 Then
                    Select Case UCase(TypeName(lControl))
                        Case "TEXTBOX"
                            lPath(lIdxPattern) = lControl.Text & SEP & lControl.Text
                        Case "ARMCOMBOBOX"
                            lPath(lIdxPattern) = lControl.SelectedItem.Key & SEP & lControl.SelectedItem.DisplayText
                        Case Else
                            'debug.print "GetCurrentPath" & UCase(TypeName(lControl))
                    End Select
                Exit For
                End If
            Next
        End If
        Set lControl = Nothing
    Next

    Dim lBuffer As String
    lBuffer = Join(lPath, SEP & SEP)
    lBuffer = Replace(lBuffer, "year", Year(cal_StartDate.date_courte) & SEP & Year(cal_StartDate.date_courte), , , vbTextCompare)
    'PUT HERE the exceptions
    GetCurrentPath = lBuffer

Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":GetCurrentPath"


End Function

' Return true if have created the node
Private Function FindInTreeView(ByVal aTV As ArmTreeView, ByVal aPath As String) As Boolean

On Error GoTo Trace_Err

    mTVDisable = True

    Dim lValues As Variant
    lValues = Split(aPath, SEP & SEP)

    Dim lIdx As Long, lCount As Long, lFoundedCount As Long
    lCount = UBound(lValues)
    Dim lData As Variant, lKey As String, lValue As String
    
    lData = Split(lValues(0), SEP)
    lKey = lData(0)
    lValue = lData(1)
    
    If Not aTV.Find(lKey, 0, , 0) Then
        aTV.AddNode(, lKey, lValue, 1, 2).Selected = True
        FindInTreeView = True
    End If
    
    lFoundedCount = 1
    Call aTV.ExpandNode(aTV.SelectedItem)

    For lIdx = 1 To lCount
        lData = Split(lValues(lIdx), SEP)
        lKey = lData(0)
        lValue = lData(1)
        If Not aTV.Find(lKey, 0, aTV.SelectedItem, lIdx) Then
            aTV.AddNode(aTV.SelectedItem, lKey, lValue, 1, 2).Selected = True
            FindInTreeView = True
        End If
        Call aTV.ExpandNode(aTV.SelectedItem)
        lFoundedCount = lFoundedCount + 1
    Next

Trace_End:
    mTVDisable = False
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":FindInTreeView"
    mTVDisable = False
End Function



Private Sub Item_ExitToView()

On Error GoTo Trace_Err

    fraItem.Visible = False
    Call LocalToForm(mSeminar)
    Call Item_ViewInit
    fraItem.Visible = True

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_ExitToView"

End Sub


Private Sub grList_ItemSelected()

On Error GoTo Trace_Err

    Screen.MousePointer = vbHourglass
    Call Item_Load(grList.CurrentKey(0), emView)
    Screen.MousePointer = 0
Trace_End:
    Exit Sub

Trace_Err:
    Screen.MousePointer = 0
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":grList_ItemSelected"
   
End Sub


Private Sub Item_Load(ByVal aSM_Code As Long, ByVal aMode As eMode)
  
  On Error GoTo Trace_Err
    
    If mMode <> emView Then
        mSeminar = DBToLocal(aSM_Code)
    End If
    Call EnableFrame(UserControl.Controls, fraFilters, False)
    fraList.Visible = False
    fraItem.Visible = False
    Call LocalToForm(mSeminar)
    Call fraItem.Move(fraList.Left, fraList.Top, fraList.Width, fraList.Height)
    Call ResizeFrameCustomer
    
    Select Case aMode
        Case eMode.emDelete
            Call Item_DeleteInit
        Case eMode.emView
            Call Item_ViewInit
        Case eMode.emUpdate
            Call Item_UpdateInit
        Case Else
            'debug.print "Invalid call of item_load"
    End Select
    fraItem.Visible = True

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_Load"


End Sub

Private Function DBToLocal(ByVal aSM_Code As Long) As TSeminar

On Error GoTo Trace_Err

    Const DB_SM_REQUEST As String = "Cap_Seminars_Sel '$language_code$', $sm_code$"
    Const DB_CS_REQUEST As String = "Cap_Seminars_Actions_lst $sm_code$, '$language_code$'"
    
    Dim lRequest As String, lRequestCustomer As String
    lRequest = ReplaceCommonHolders(DB_SM_REQUEST)
    lRequest = Replace(lRequest, "$sm_code$", aSM_Code, , , vbTextCompare)
    
    lRequestCustomer = ReplaceCommonHolders(DB_CS_REQUEST)
    lRequestCustomer = Replace(lRequestCustomer, "$sm_code$", aSM_Code, , , vbTextCompare)
    
    
    Dim lData As Long, lCustomers As Long
    lData = mDb.OpenSQL(lRequest)
    If lData = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:DBToLocal", "Requests=", lRequest
        GoTo Trace_End
    End If
    
    lCustomers = mDb.OpenSQL(lRequestCustomer)
    If lCustomers = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:DBToLocal", "Requests=", lRequestCustomer
        GoTo Trace_End
    End If
    
    Dim lSeminar As TSeminar
    lSeminar.SM_Code = aSM_Code
    lSeminar.CT_Code = mDb.GetFields(lData, "CT_Code")
    lSeminar.CT_Desc = mDb.GetFields(lData, "CT_Desc")
    lSeminar.iConcurrency = mDb.GetFields(lData, "iConcurrency")
    lSeminar.Language_Code = "E"
    lSeminar.NoCptCstCount = mDb.GetFields(lData, "NoCptCstCount")
    lSeminar.Owner = mDb.GetFields(lData, "Owner")
    lSeminar.SM_Comment = mDb.GetFields(lData, "SM_Comment")
    lSeminar.SM_Desc = mDb.GetFields(lData, "SM_Desc")
    lSeminar.SM_EndDate = mDb.GetFields(lData, "SM_EndDate")
    lSeminar.SM_SP1 = mDb.GetFields(lData, "SM_SP1")
    lSeminar.SM_SP2 = mDb.GetFields(lData, "SM_SP2")
    lSeminar.SM_SP3 = mDb.GetFields(lData, "SM_SP3")
    lSeminar.SM_SP4 = mDb.GetFields(lData, "SM_SP4")
    lSeminar.SM_StartDate = mDb.GetFields(lData, "SM_StartDate")
    lSeminar.TotalCstCount = mDb.GetFields(lData, "TotalCstCount")
    lSeminar.Z_Creation = mDb.GetFields(lData, "Z_Creation")
    lSeminar.Z_Creator = mDb.GetFields(lData, "Z_Creator")
    lSeminar.Z_Last_Upd = mDb.GetFields(lData, "Z_Last_Upd")
    lSeminar.Z_Last_Upd_User = mDb.GetFields(lData, "Z_Last_Upd_User")
    
    
    Dim lIdx As Long, lCount As Long
    lCount = mDb.RowCount(lCustomers) - 1
    If lCount = -1 Then
        ReDim lSeminar.Customers(-1 To -1)
    Else
        ReDim lSeminar.Customers(lCount)
        Dim lCustomer As TCustomer
        For lIdx = 0 To lCount
            lCustomer.AC_Code = mDb.GetFields(lCustomers, "AC_Code")
            lCustomer.CCT_Desc = mDb.GetFields(lCustomers, "CCT_Desc")
            lCustomer.CCU_CapKey = mDb.GetFields(lCustomers, "CCU_Capkey")
            lCustomer.CCU_Desc = mDb.GetFields(lCustomers, "CCU_Desc")
            lCustomer.CCU_Town = mDb.GetFields(lCustomers, "CCU_Town")
            lCustomer.CCU_Zip = mDb.GetFields(lCustomers, "CCU_Zip")
            lCustomer.CNT_Code = mDb.GetFields(lCustomers, "CNT_Code")
            lCustomer.CNT_Name = mDb.GetFields(lCustomers, "CNT_Name")
            lCustomer.CNT_TelOffice = mDb.GetFields(lCustomers, "CNT_TelOffice")
            lCustomer.TIT_Desc = mDb.GetFields(lCustomers, "TIT_Desc")
            lCustomer.JOB_Desc = mDb.GetFields(lCustomers, "JOB_Desc")
            lSeminar.Customers(lIdx) = lCustomer
            mDb.Next (lCustomers)
        Next
    End If
    
    mDb.Close (lData)
    mDb.Close (lCustomers)
    DBToLocal = lSeminar

Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":DBToLocal"
End Function


Private Sub LocalToForm(ByRef aSeminar As TSeminar)
    
On Error GoTo Trace_Err
    
    Call ClearForm(UserControl.Controls, fraItem)
    
    txt_SMCode.Text = aSeminar.SM_Code
    If Not cbo_country.SearchItem(aSeminar.CT_Code, 0, , True) Then
        Call cbo_country.AddItem(Array(aSeminar.CT_Code, aSeminar.CT_Desc), True)
    End If
    Txt_name.Text = aSeminar.SM_Desc
    txt_comment.Text = aSeminar.SM_Comment
    If Not cbo_Owner.SearchItem(aSeminar.Owner, 0, , True) Then
        Call cbo_Owner.AddItem(Array(aSeminar.Owner, aSeminar.Owner), True)
    End If
    txt_DateEntered.Text = Format(aSeminar.Z_Creation, "DD/MM/YYYY")
    txt_CreatedBy.Text = aSeminar.Z_Creator
    txt_LastUpdate.Text = Format(aSeminar.Z_Last_Upd, "DD/MM/YYYY")
    txt_LastUpdatedBy.Text = aSeminar.Z_Last_Upd_User
    
    cal_StartDate.date_courte = aSeminar.SM_StartDate
    cal_EndDate.date_courte = aSeminar.SM_EndDate
    
    txt_TotalCount.Text = aSeminar.TotalCstCount
    txt_spare1.Text = aSeminar.SM_SP1
    txt_spare2.Text = aSeminar.SM_SP2
    txt_spare3.Text = aSeminar.SM_SP3
    txt_spare4.Text = aSeminar.SM_SP4
    
    Dim lIdx As Long, lCount As Long, lCustomer As TCustomer
    lCount = UBound(aSeminar.Customers)
    
    For lIdx = 0 To lCount
        lCustomer = aSeminar.Customers(lIdx)
        If Not grCustomers.AddLine(Array(lCustomer.CCU_CapKey, lCustomer.CNT_Code, lCustomer.AC_Code, lCustomer.CCU_Desc, lCustomer.CCU_Town, lCustomer.CCU_Zip, lCustomer.CCT_Desc, lCustomer.TIT_Desc, lCustomer.CNT_Name, lCustomer.JOB_Desc, lCustomer.CNT_TelOffice)) Then
            Call MsgBox(MsgText(1121, mLanguage_Code, "Unable to add this customer to the list: ") & lCustomer.CCT_Desc, vbYesNo)
        End If
    Next
    
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":LocalToForm"
 
    
End Sub


Private Sub Item_ViewInit()

On Error GoTo Trace_Err

    SetMode (emView)
    Call EnableFrame(UserControl.Controls, fraItem, False)
    tbItem.ClearAllIcons
    tbItem.PictureDisplayed = "P_Update=2 P_Delete=3 P_Previous=4 P_Next=5 P_Quit=-1"
    tbCustomer.Visible = False
    
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_ViewInit"
    
End Sub


Private Sub tbItem_action(ByVal as_ActionType As String)
    
On Error GoTo Trace_Err

    Screen.MousePointer = vbHourglass

    Select Case UCase$(as_ActionType)
        Case "VALID"
            Select Case mMode
                Case eMode.emAdd
                    Call Item_Add
                Case eMode.emDelete
                    Call Item_Delete
                Case eMode.emUpdate
                    Call Item_Update
            End Select
        
        Case "PREVIOUS"
            Call GotoPreviousItem
        Case "NEXT"
            Call GotoNextItem
        Case "UPDATE"
            fraItem.Visible = False
            Call Item_UpdateInit
            fraItem.Visible = True
        Case "DELETE"
            fraItem.Visible = False
            Call Item_DeleteInit
            fraItem.Visible = True
        Case "QUIT"
            Select Case mMode
                Case eMode.emView, eMode.emAdd
                    Call Item_ExitToGrid
                Case eMode.emDelete, eMode.emUpdate
                    If mOldMode = emList Then
                        Call Item_ExitToGrid
                    Else
                        Call Item_ExitToView
                    End If
                Case Else
            End Select
        Case "UNDO"
            Select Case mMode
                Case eMode.emAdd
                    Call Item_AddClear
                Case eMode.emUpdate
                    Call Item_Load(mSeminar.SM_Code, emUpdate)
            End Select
    End Select
    
Trace_End:
    Screen.MousePointer = vbDefault
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":tbItem_action"
    Screen.MousePointer = vbDefault

End Sub

Private Sub GotoPreviousItem()
On Error GoTo Trace_Err
    
    If Not grList.PreviousItem Then
        Call SendMessage(927, "#No more previous item", mLanguage_Code)
    End If

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":GotoPreviousItem"
    
End Sub

Private Sub GotoNextItem()
On Error GoTo Trace_Err
    If Not grList.NextItem Then
        Call SendMessage(928, "#No more next item", mLanguage_Code)
    End If
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":GotoNextItem"
  
End Sub

Private Sub Item_DeleteInit()
    
On Error GoTo Trace_Err
    
    SetMode (emDelete)
    If mOldMode <> emView Then
        Call EnableFrame(UserControl.Controls, fraItem, False)
    End If
    tbItem.ClearAllIcons
    tbItem.PictureDisplayed = "P_Valid=1 P_Quit=-1"
    tbCustomer.Visible = False
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_DeleteInit"
    
End Sub


Private Function Item_Delete() As Boolean
    
    On Error GoTo Trace_Err
    
    If MsgBox(MsgText(939, mLanguage_Code, "Do you really want to delete this record?"), vbYesNo) <> vbYes Then Exit Function
    If Not Item_DbDelete(mSeminar) Then Exit Function
    Item_LocalDelete (mSeminar.SM_Code)
    Call Item_ExitToGrid
    Item_Delete = True
Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_Delete"

End Function


Private Function Item_LocalDelete(ByVal aSM_Code As Long) As Boolean
    On Error GoTo Trace_Err
    
    Item_LocalDelete = grList.DeleteLine(aSM_Code)

Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_LocalDelete"
    
End Function


Function MsgText(aID As Long, aLang As String, ByVal aDefault As String) As String

    Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = Replace(DB_REQ, "$id$", aID)
    lRequest = Replace(lRequest, "$lang$", aLang)
    
    Dim lData As Long
    lData = mDb.OpenSQL(lRequest)
    
    If lData = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:MsgText", "Requests=", lRequest
    End If
    
    Dim lBuffer As String
    lBuffer = mDb.GetFields(lData, "message_text")
    mDb.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    MsgText = lBuffer
    
End Function


Private Sub Item_UpdateInit()
    
On Error GoTo Trace_Err
    
    SetMode (emUpdate)
    
    msrzActionDel = ""
    msrzCustomerToAdd = ""
    If mOldMode <> emView Then
        Call EnableFrame(UserControl.Controls, fraItem, False)
    End If
    tbItem.ClearAllIcons
    tbItem.PictureDisplayed = "P_Valid=1 P_Undo=2 P_Quit=-1"
    
    tbCustomer.Visible = True
    
    Call EnableFrame(UserControl.Controls, fraItem, True)
    Call EnableFrame(UserControl.Controls, fraItemInfo, False)
    cbo_Owner.Enabled = False
    Call EnableTextBox(txt_SMCode, False)

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_UpdateInit"
   
End Sub

Private Sub Item_Update()
    
    On Error GoTo Trace_Err
    
    If Not Item_Check Then Exit Sub
    
    Dim lSeminar As TSeminar
     
    If Not FormToLocal(lSeminar) Then
        Call SendMessage(1119, "Unable to extract the data from the form", mLanguage_Code)
        Exit Sub
    End If
 
    lSeminar.SM_Code = mSeminar.SM_Code
    lSeminar.iConcurrency = mSeminar.iConcurrency
   
    If Not Item_DBUpdate(lSeminar, mSeminar.Customers) Then
        Call SendMessage(1122, "Unable to update the data", mLanguage_Code)
        Exit Sub
        
    End If
    lSeminar.Z_Creation = mSeminar.Z_Creation
    lSeminar.Z_Creator = mSeminar.Z_Creator
    lSeminar.Z_Last_Upd = Date
    lSeminar.Z_Last_Upd_User = mLoginName
    lSeminar.iConcurrency = lSeminar.iConcurrency + 1

    Call Item_LocalUpdate
    If mOldMode = emList Then
        Call Item_ExitToGrid
    Else
        mSeminar = lSeminar
        Call Item_ExitToView
    End If
    
    Exit Sub
    
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_Update"


End Sub

Private Function Item_LocalUpdate() As Boolean
    
    On Error GoTo Trace_Err
    
    Dim lPath As String
    lPath = GetCurrentPath(UserControl.Controls, fraItem, cbo_Views.SelectedItem.GetData(2))
    If FindInTreeView(tvitems, lPath) Then
       ' FOR NEXT TIME Item has been created, we can here write a network optimisation if we know what to put in the grid
        grList.Requests = ApplyTVFilters(tvitems.SelectedNodeRequest)
        If grList.Execute = False Then Debug.Print "unable to load the grid"
    Else
         grList.Requests = ApplyTVFilters(tvitems.SelectedNodeRequest)
        If grList.Execute = False Then Debug.Print "unable to load the grid"
    End If
    
    If Not grList.SearchKey(True, Array(mSeminar.SM_Code)) Then
        ' ERROR
        'debug.print "unable to find the item"
    End If
    Item_LocalUpdate = True

Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_LocalUpdate"

End Function


Private Sub ResizeFrameCustomer()

On Error GoTo Trace_Err

    Dim lLeft As Long, lWidth As Long, lTop As Long, lHeight As Long

    lLeft = 120
    lWidth = fraItem.Width - lLeft - 120
    lTop = fraItemData.Top + fraItemData.Height + 120
    lHeight = fraItem.Height - lTop - 120
    Call fraItemCustomers.Move(lLeft, lTop, lWidth, lHeight)
    
    lTop = 240
    lHeight = fraItemCustomers.Height - lTop - 120
    lWidth = tbCustomer.Width
    lLeft = fraItemCustomers.Width - 120 - lWidth
    Call tbCustomer.Move(lLeft, lTop, lWidth, lHeight)
    
    lLeft = 120
    lWidth = tbCustomer.Left - 240
    lTop = 240
    lHeight = fraItemCustomers.Height - lTop - 120
    Call grCustomers.Move(lLeft, lTop, lWidth, lHeight)

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":ResizeFrameCustomer"

End Sub


Private Function Item_AddInit()
    
On Error GoTo Trace_Err

    Call SetMode(emAdd)
    
    fraItem.Visible = False
    fraList.Visible = False
    fraFilters.Visible = False
    
    Call fraItem.Move(fraFilters.Left, fraFilters.Top, UserControl.Width - 120, fraFilters.Height)
    Call ResizeFrameCustomer

    Call EnableFrame(UserControl.Controls, fraItem, True)
    Call EnableFrame(UserControl.Controls, fraFilters, False)
    Call EnableFrame(UserControl.Controls, fraItemInfo, False)
    Call EnableTextBox(txt_SMCode, False)
    
    tbItem.ClearAllIcons
    tbItem.PictureDisplayed = "P_Valid=1 P_Undo=2 P_Quit=-1"
    
    tbCustomer.Visible = True
    
    Call Item_AddClear
    
    fraItem.ZOrder
    fraItem.Visible = True
        
Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_AddInit"
        
        
End Function


Private Sub tbCustomer_action(ByVal as_ActionType As String)

On Error GoTo Trace_Err

    Screen.MousePointer = vbHourglass
    
    Select Case UCase$(as_ActionType)
        Case "ADD"
            Call Customer_Add
        Case "DELETE"
            Call Customer_Delete
        Case "UNDO"
            Call Customer_Clear
    End Select
Trace_End:
    Screen.MousePointer = vbDefault
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":tbCustomer_action"
   
End Sub


Private Function Customer_LocalAdd(ByVal aSrz As String) As Boolean

On Error GoTo Trace_Err

    Dim lBuffer As Variant, lFields As Variant, lItem As Variant
    Dim lIdx As Long, lCount As Long, lIdxCol As Long, lCountCol As Long
    lBuffer = Split(aSrz, SEP & SEP)
    lCount = UBound(lBuffer)
    ReDim lFields(lCount)
    For lIdx = 0 To lCount
        lFields(lIdx) = Split(lBuffer(lIdx), SEP)
    Next
    
    lCountCol = grCustomers.Cols - 1
    ReDim lItem(lCountCol)
    For lIdxCol = 0 To lCountCol
        For lIdx = 0 To lCount
            If StrComp(lFields(lIdx)(0), grCustomers.Columns(lIdxCol).Name, vbTextCompare) = 0 Then
                lItem(lIdxCol) = lFields(lIdx)(1)
                Exit For
            End If
        Next
        If StrComp(grCustomers.Columns(lIdxCol).Name, "AC_CODE", vbTextCompare) <> 0 Then
            If lItem(lIdxCol) = "" And grCustomers.Columns(lIdxCol).Key Then
                Call MsgBox(MsgText(1121, mLanguage_Code, "Unable to add this customer to the list: ") & grCustomers.Columns(lIdxCol).Name, vbYesNo)
            End If
        End If
    Next
    Call grCustomers.AddLine(lItem)
    Customer_LocalAdd = True

Trace_End:
    Exit Function
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Customer_LocalAdd"
    
    
End Function

Private Function Customer_LocalExists(ByVal aCCU_Capkey As String) As Long
On Error GoTo Trace_Err

    Dim lIdx As Long, lCount As Long
    lCount = UBound(mSeminar.Customers)
    For lIdx = 0 To lCount
        If StrComp(mSeminar.Customers(lIdx).CCU_CapKey, aCCU_Capkey, vbTextCompare) = 0 Then
            Customer_LocalExists = lIdx
            Exit Function
        End If
    Next
    Customer_LocalExists = 0
Trace_End:
    Exit Function
Trace_Err:
    Customer_LocalExists = 0
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Customer_LocalExists"
    
End Function


Private Sub Customer_Delete()
    
 On Error GoTo Trace_Err
 
    Dim lIdx As Long, lCount As Long
    lCount = grCustomers.SelectedCount - 1
    If lCount < 0 Then Exit Sub
    
    If MsgBox(MsgText(1010, mLanguage_Code, "#Attention, voulez vous vraiment supprimer toutes les donnes slectionnes ?"), vbYesNo) = vbYes Then
        Dim lKeys As Variant, lAC_Code As String
        ' First, store the id to delete
        For lIdx = 0 To lCount
            lAC_Code = grCustomers.SelectedLine(lIdx, "AC_Code")
            If lAC_Code <> "" Then
                msrzActionDel = IIf(Len(msrzActionDel) <> 0, msrzActionDel & SEP, "") & lAC_Code
            End If
        Next
        ' Then delete line from grid
        lKeys = grCustomers.MultiSelectedKey
        For lIdx = 0 To lCount
            grCustomers.DeleteLine (lKeys(lIdx))
        Next
        grCustomers.DeselectRow
    End If
    
Trace_End:
       Exit Sub
       
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Customer_Delete"
    
End Sub
 
        
Private Sub Customer_Clear()
    
    On Error GoTo Trace_Err
    
    If MsgBox(MsgText(1009, mLanguage_Code, "#Do you really want to remove all the data?"), vbYesNo) = vbYes Then
        grCustomers.ClearGrid
    End If

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Customer_Clear"

    
End Sub


Private Function GetActionComment(ByRef aSeminar As TSeminar) As String

On Error GoTo Trace_Err

    Dim lBuffer As String
    
    lBuffer = aSeminar.SM_Desc & vbCrLf & mLoginName & vbCrLf & Date
    
    GetActionComment = lBuffer
Trace_End:
    Exit Function

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":ApplyTVFilters"

End Function



Private Function Item_DbAdd(ByRef aSeminar As TSeminar) As Boolean

On Error GoTo Trace_Err

    Const DB_SM_REQUEST As String = "EXEC Cap_Seminar_Ins $sm_code$, '$ct_code$', '$sm_desc$', '$sm_comment$', '$sm_startdate$', '$sm_enddate$', '$owner$', $totalcstcount$, $nocptcstcount$, '$sm_sp1$', '$sm_sp2$', '$sm_sp3$', '$sm_sp4$'"
    Const DB_AC_REQUEST As String = "EXEC Cap_Action_Ins2 '$ac_code$', '$ccu_capkey$', $at_code$, $as_code$, $ar_code$, '$z_user$' "    ' taks 299.3 removed $act_comment$
    Const DB_CM_REQUEST As String = "EXEC Cap_Memo_ins 'E', '$Comment_desc$', '$Comment$', 'N', 'N', Null, '$AC_CODE$', '', 2, 0, '$MEM_Code$'"       ' task 299.3
    Const DB_LK_REQUEST As String = "EXEC Cap_Seminars_Actions_Ins $sm_code$, '$ac_code$', '$ccu_capkey$'"
    Const DB_CN_REQUEST As String = "EXEC Cap_ActionContact_ins '$ac_code$', '$ccu_capkey$', '$cnt_code$', '$z_user$' "
    
    Const IDX_AC As Long = 0
    Const IDX_LK As Long = 1
    Const IDX_CN As Long = 2
    Const IDX_CM As Long = 3    ' task 299.3 Comment insert
    
    Dim lRequest As String, lTranOpenned As Boolean, lKey As Long, lLinks As Variant, lIdx As Long, lCount As Long, lBuffer As String, lStrKey As String
    Dim ls_comment As String    ' task 299.3
    
    If Not GetNextKey("Cap_Seminars", aSeminar.SM_Code) Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbAdd", "Requests=Cap_Seminars:GetNextKey"
        GoTo Trace_End
    End If
    aSeminar.iConcurrency = 1
    
    lRequest = ReplaceCommonHolders(DB_SM_REQUEST)
    lRequest = ReplaceHoldersFromLocal(lRequest, aSeminar)
    
    Dim ls_MEM_Code As String
    
    lCount = UBound(aSeminar.Customers)
    If lCount = -1 Then
        ReDim lKeys(-1 To -1)
        ReDim lLinks(-1 To -1, -1 To -1)
    Else
        ReDim lKeys(lCount)
        ReDim lLinks(3, lCount)     ' task 299.3 incremented to 3
    
        For lIdx = 0 To lCount
            If Not GetNextKey("Cap_Seminars_Actions", lKey) Then
               If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbAdd", "Requests=Cap_Seminars_Actions:GetNextKey"
               GoTo Trace_End
            End If
            
            lStrKey = "SM" & right("00000000000000" & lKey, 14)
            
            lBuffer = ReplaceCommonHolders(DB_AC_REQUEST)
            lBuffer = Replace(lBuffer, "$ccu_capkey$", aSeminar.Customers(lIdx).CCU_CapKey, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$ac_code$", lStrKey, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$at_code$", mDft_AT_Code, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$as_code$", mDft_AS_Code, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$ar_code$", mDft_AR_Code, , , vbTextCompare)
'            lBuffer = Replace(lBuffer, "$act_comment$", Replace(GetActionComment(aSeminar), "'", "''", , , vbTextCompare), , , vbTextCompare)  ' task299.3
            lBuffer = Replace(lBuffer, "$z_user$", aSeminar.Owner, , , vbTextCompare)
            lLinks(IDX_AC, lIdx) = lBuffer
            
            lBuffer = ReplaceCommonHolders(DB_LK_REQUEST)
            lBuffer = Replace(lBuffer, "$sm_code$", aSeminar.SM_Code, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$ccu_capkey$", aSeminar.Customers(lIdx).CCU_CapKey, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$ac_code$", lStrKey, , , vbTextCompare)
            
            lLinks(IDX_LK, lIdx) = lBuffer
            
            lBuffer = ReplaceCommonHolders(DB_CN_REQUEST)
            lBuffer = Replace(lBuffer, "$ccu_capkey$", aSeminar.Customers(lIdx).CCU_CapKey, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$ac_code$", lStrKey, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$cnt_code$", aSeminar.Customers(lIdx).CNT_Code, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$z_user$", aSeminar.Owner, , , vbTextCompare)
            lLinks(IDX_CN, lIdx) = lBuffer
            
'task299.3 begin
            ' insert into cap_memo only 'E' language record, memo type=2(spare3_real)
            ls_comment = GetActionComment(aSeminar)
            
                ls_MEM_Code = mDb.SQLNextID("Cap_Memo")
                If ls_MEM_Code = "" Then Call Err.Raise(SQLFailure, "", "SQL Error: mo_ArmDb.SQLNextID(""Cap_Memo"") return nothing.")
    
                ' create memo
                lBuffer = Replace(DB_CM_REQUEST, "$Comment$", Replace(ls_comment, "'", "''", , , vbTextCompare), , , vbTextCompare)  ' task 299.3
                lBuffer = Replace(lBuffer, "$Comment_desc$", Replace(Left(ls_comment, 80), "'", "''", , , vbTextCompare), , , vbTextCompare)
                lBuffer = Replace(lBuffer, "$AC_CODE$", lStrKey, , , vbTextCompare)
                lBuffer = Replace(lBuffer, "$MEM_Code$", ls_MEM_Code)
                
                lLinks(IDX_CM, lIdx) = lBuffer
'task299.3 end

        Next
    End If
    
    If Not mDb.ExecuteSQL("BEGIN TRAN Item_DbAdd") Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbAdd", "Requests=", "BEGIN TRAN Item_DbAdd"
        GoTo Trace_End
    End If
    lTranOpenned = True
    
    If Not mDb.ExecuteSQL(lRequest) Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbAdd", "Requests=", lRequest
        GoTo Trace_End
    End If
    
    lCount = UBound(lLinks, 2)
    Dim lIdxReq As Long, lCountReq As Long
    lCountReq = UBound(lLinks, 1)
    For lIdx = 0 To lCount
        For lIdxReq = 0 To lCountReq
            If Not mDb.ExecuteSQL(lLinks(lIdxReq, lIdx)) Then
                If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbAdd", "Requests=", lLinks(lIdxReq, lIdx)
                GoTo Trace_End
            End If
        Next
    Next
    
    If Not mDb.ExecuteSQL("COMMIT TRAN Item_DbAdd") Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbAdd", "Requests=", "COMMIT TRAN Item_DbAdd"
        GoTo Trace_End
    End If
    lTranOpenned = False
    
    Item_DbAdd = True
    
Trace_End:
    If lTranOpenned Then
        If Not mDb.ExecuteSQL("ROLLBACK TRAN Item_DbAdd") Then
            If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbAdd", "Requests=", "ROLLBACK TRAN Item_DbAdd"
            Call ASC_SendMessage(mDb, mLanguage_Code, 891, "#An error occured during this manipulation, please contact your IT support")
            End
        End If
    End If
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_DbAdd"
    If lTranOpenned Then
        If Not mDb.ExecuteSQL("ROLLBACK TRAN Item_DbAdd") Then
            If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbAdd", "Requests=", "ROLLBACK TRAN Item_DbAdd"
            Call ASC_SendMessage(mDb, mLanguage_Code, 891, "#An error occured during this manipulation, please contact your IT support")
            End
        End If
    End If
End Function


Private Function Item_DbDelete(ByRef aSeminar As TSeminar) As Boolean

    On Error GoTo Err_Item_DbDelete
    
    Const IDX_CM As Long = 2    ' task 299.3 Comment insert
    Const IDX_AC As Long = 3
    Const IDX_LK As Long = 0
    Const IDX_CN As Long = 1

    Const DB_SM_REQUEST As String = "exec Cap_Seminars_Del $sm_code$, $iconcurrency$"
    Const DB_AC_DEL_REQUEST As String = "EXEC Cap_Action_Del2 '$ac_code$'"
    Const DB_CM_DEL_REQUEST As String = "EXEC Cap_Memo_Comment_del '$ac_code$', 2"
    Const DB_LK_DEL_REQUEST As String = "EXEC Cap_Seminars_Actions_Del $sm_code$, '$ac_code$'"
    Const DB_CN_DEL_REQUEST As String = "EXEC Cap_ActionContact_Del2 '$ac_code$'"

    Dim lRequest As String, lIdx As Long, lCount As Long, lTranOpenned As Boolean, lToDelete As Variant, lBuffer As String
    
    lRequest = Replace(DB_SM_REQUEST, "$sm_code$", aSeminar.SM_Code, , , vbTextCompare)
    lRequest = Replace(lRequest, "$iconcurrency$", aSeminar.iConcurrency, , , vbTextCompare)

    lCount = UBound(aSeminar.Customers)
    If lCount = -1 Then
        ReDim lToDelete(-1 To -1, -1 To -1)
    Else
        ReDim lToDelete(3, lCount)  ' taks 299.3  -- increment dimension to 3
        For lIdx = 0 To lCount
            lBuffer = ReplaceCommonHolders(DB_AC_DEL_REQUEST)
            lBuffer = Replace(lBuffer, "$ac_code$", aSeminar.Customers(lIdx).AC_Code)
            lToDelete(IDX_AC, lIdx) = lBuffer
            
            lBuffer = ReplaceCommonHolders(DB_LK_DEL_REQUEST)
            lBuffer = Replace(lBuffer, "$ac_code$", aSeminar.Customers(lIdx).AC_Code)
            lBuffer = Replace(lBuffer, "$sm_code$", aSeminar.SM_Code, , , vbTextCompare)
            lToDelete(IDX_LK, lIdx) = lBuffer
            
            lBuffer = ReplaceCommonHolders(DB_CN_DEL_REQUEST)
            lBuffer = Replace(lBuffer, "$ac_code$", aSeminar.Customers(lIdx).AC_Code)
            lToDelete(IDX_CN, lIdx) = lBuffer

' task 299.3 begin
            ' delete comment, we don't care if exists or not
            lBuffer = Replace(DB_CM_DEL_REQUEST, "$ac_code$", aSeminar.Customers(lIdx).AC_Code)
            lToDelete(IDX_CM, lIdx) = lBuffer
' task 299.3 end
        Next
    
    End If
    
    If Not mDb.ExecuteSQL("BEGIN TRAN Item_DbDelete") Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbDelete", "Requests=", "BEGIN TRAN Item_DbDelete"
        GoTo Trace_End
    End If
    lTranOpenned = True

    lCount = UBound(lToDelete, 2)
    Dim lIdxReq As Long, lCountReq As Long
    lCountReq = UBound(lToDelete, 1)
    For lIdx = 0 To lCount
        For lIdxReq = 0 To lCountReq
            If Not mDb.ExecuteSQL(lToDelete(lIdxReq, lIdx)) Then
                If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbDelete", "Requests=", lToDelete(lIdxReq, lIdx)
                GoTo Trace_End
            End If
        Next
    Next
    
    If Not mDb.ExecuteSQL(lRequest) Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbDelete", "Requests=", lRequest
        GoTo Trace_End
    End If

    If mDb.SQLRowsAffected = 0 Then
        Call ASC_SendMessage(mDb, mLanguage_Code, 916, "#This data has been updated by another user. Data will be reloaded. Please check the data and try again.")
        GoTo Trace_End
    End If
    
    If Not mDb.ExecuteSQL("COMMIT TRAN Item_DBUpdate") Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbDelete", "Requests=", "COMMIT TRAN Item_DBUpdate"
        GoTo Trace_End
    End If
    lTranOpenned = False
    Item_DbDelete = True
    
Trace_End:
    If lTranOpenned Then
        If Not mDb.ExecuteSQL("ROLLBACK TRAN Item_DbDelete") Then
            If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbDelete", "Requests=", "ROLLBACK TRAN Item_DbAdd"
            Call ASC_SendMessage(mDb, mLanguage_Code, 891, "#An error occured during this manipulation, please contact your IT support")
            End
        End If
    End If
    Exit Function
    
Err_Item_DbDelete:
    If lTranOpenned Then
        If Not mDb.ExecuteSQL("ROLLBACK TRAN Item_DbDelete") Then
            If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DbDelete", "Requests=", "ROLLBACK TRAN Item_DbAdd"
            Call ASC_SendMessage(mDb, mLanguage_Code, 891, "#An error occured during this manipulation, please contact your IT support")
            End
        End If
    End If
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_DbDelete"

End Function


Private Function Item_DBUpdate(ByRef aSeminar As TSeminar, ByRef aCurrentCustomers() As TCustomer) As Boolean
    
    Const IDX_CM As Long = 2    ' task 299.3 Comment insert
    Const IDX_AC As Long = 3
    Const IDX_LK As Long = 0
    Const IDX_CN As Long = 1
    
    Const DB_SM_REQUEST As String = "EXEC Cap_Seminar_Upd $sm_code$, '$ct_code$', '$sm_desc$', '$sm_comment$', '$sm_startdate$', '$sm_enddate$', '$owner$', $totalcstcount$, $nocptcstcount$, '$sm_sp1$', '$sm_sp2$', '$sm_sp3$', '$sm_sp4$', $iconcurrency$"
    
    Const DB_AC_DEL_REQUEST As String = "EXEC Cap_Action_Del2 '$ac_code$'"
    Const DB_CM_DEL_REQUEST As String = "EXEC Cap_Memo_Comment_del '$ac_code$', 2"
    Const DB_LK_DEL_REQUEST As String = "EXEC Cap_Seminars_Actions_Del $sm_code$, '$ac_code$'"
    Const DB_CN_DEL_REQUEST As String = "EXEC Cap_ActionContact_Del2 '$ac_code$'"

    Const DB_AC_INS_REQUEST As String = "EXEC Cap_Action_Ins2 '$ac_code$', '$ccu_capkey$', $at_code$, $as_code$, $ar_code$, '$z_user$' "    ' taks 299.3 removed $act_comment$
    Const DB_CM_INS_REQUEST As String = "EXEC Cap_Memo_ins 'E', '$Comment_desc$', '$Comment$', 'N', 'N', Null, '$AC_CODE$', '', 2, 0, '$MEM_Code$'"           ' task 299.3
    Const DB_LK_INS_REQUEST As String = "EXEC Cap_Seminars_Actions_Ins $sm_code$, '$ac_code$', '$ccu_capkey$'"
    Const DB_CN_INS_REQUEST As String = "EXEC Cap_ActionContact_ins '$ac_code$', '$ccu_capkey$', '$cnt_code$', '$z_user$' "

    On Error GoTo Err_ItemDBUpdate
    
    Dim lRequest As String, lTranOpenned As Boolean, lToDelete As Variant, lToAdd As Variant
    Dim lIdx As Long, lCount As Long, lKey As Long, lStrKey As String
    Dim ls_comment As String    ' task299.3
    
    lRequest = ReplaceCommonHolders(DB_SM_REQUEST)
    lRequest = ReplaceHoldersFromLocal(lRequest, aSeminar)
    
    Dim ls_MEM_Code As String
    
    
    Dim lArray As Variant, lBuffer As String
    If Len(aSeminar.srzActionDel) = 0 Then
        ReDim lToDelete(1, -1 To -1)
    Else
        lArray = Split(aSeminar.srzActionDel, SEP, , vbTextCompare)
        lCount = UBound(lArray)
        ReDim lToDelete(3, lCount)  ' taks 299.3  -- increment dimension to 3
        For lIdx = 0 To lCount
            lBuffer = ReplaceCommonHolders(DB_AC_DEL_REQUEST)
            lBuffer = Replace(lBuffer, "$ac_code$", lArray(lIdx))
            lToDelete(IDX_AC, lIdx) = lBuffer
            
            lBuffer = ReplaceCommonHolders(DB_CN_DEL_REQUEST)
            lBuffer = Replace(lBuffer, "$ac_code$", lArray(lIdx))
            lToDelete(IDX_CN, lIdx) = lBuffer
            
            lBuffer = ReplaceCommonHolders(DB_LK_DEL_REQUEST)
            lBuffer = Replace(lBuffer, "$ac_code$", lArray(lIdx))
            lBuffer = Replace(lBuffer, "$sm_code$", aSeminar.SM_Code, , , vbTextCompare)
            lToDelete(IDX_LK, lIdx) = lBuffer
            
' task 299.3 begin
            ' delete comment, we don't care if exists or not
            lBuffer = Replace(DB_CM_DEL_REQUEST, "$ac_code$", lArray(lIdx))
            lToDelete(IDX_CM, lIdx) = lBuffer
' task 299.3 end
        Next
    End If
    
    If Len(aSeminar.srzCustomerToAdd) = 0 Then
        ReDim lToAdd(1, -1 To -1)
    Else
        Dim lCCKey As Variant
        lArray = Split(aSeminar.srzCustomerToAdd, SEP & SEP, , vbTextCompare)
        lCount = UBound(lArray)
        ReDim lToAdd(3, lCount)     ' taks 299.3  -- increment dimension to 3
        For lIdx = 0 To lCount
            If Not GetNextKey("Cap_Seminars_Actions", lKey) Then
                Err.Raise 0
            End If
            
            lStrKey = "SM" & right("00000000000000" & lKey, 14)
            
            lCCKey = Split(lArray(lIdx), SEP)
            
            lBuffer = ReplaceCommonHolders(DB_AC_INS_REQUEST)
            lBuffer = Replace(lBuffer, "$ccu_capkey$", lCCKey(0), , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$ac_code$", lStrKey, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$at_code$", mDft_AT_Code, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$as_code$", mDft_AS_Code, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$ar_code$", mDft_AR_Code, , , vbTextCompare)
'            lBuffer = Replace(lBuffer, "$act_comment$", Replace(GetActionComment(aSeminar), "'", "''", , , vbTextCompare), , , vbTextCompare)  ' task 299.3
            lBuffer = Replace(lBuffer, "$z_user$", aSeminar.Owner, , , vbTextCompare)
            lToAdd(IDX_AC, lIdx) = lBuffer
            
            lBuffer = ReplaceCommonHolders(DB_CN_INS_REQUEST)
            lBuffer = Replace(lBuffer, "$ccu_capkey$", lCCKey(0), , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$ac_code$", lStrKey, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$cnt_code$", lCCKey(1), , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$z_user$", aSeminar.Owner, , , vbTextCompare)
            lToAdd(IDX_CN, lIdx) = lBuffer
            
            
            lBuffer = ReplaceCommonHolders(DB_LK_INS_REQUEST)
            lBuffer = Replace(lBuffer, "$sm_code$", aSeminar.SM_Code, , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$ccu_capkey$", lCCKey(0), , , vbTextCompare)
            lBuffer = Replace(lBuffer, "$ac_code$", lStrKey, , , vbTextCompare)
            lToAdd(IDX_LK, lIdx) = lBuffer
            
'task299.3 begin
            ' insert into cap_memo only 'E' language record, memo type=2(spare3_real)
            ls_comment = GetActionComment(aSeminar)
                ' create memo
                ls_MEM_Code = mDb.SQLNextID("Cap_Memo")
                If ls_MEM_Code = "" Then Call Err.Raise(SQLFailure, "", "SQL Error: mo_ArmDb.SQLNextID(""Cap_Memo"") return nothing.")
    
                lBuffer = Replace(DB_CM_INS_REQUEST, "$Comment$", Replace(ls_comment, "'", "''", , , vbTextCompare), , , vbTextCompare)  ' task 299.3
                lBuffer = Replace(lBuffer, "$Comment_desc$", Replace(Left(ls_comment, 80), "'", "''", , , vbTextCompare), , , vbTextCompare)
                lBuffer = Replace(lBuffer, "$AC_CODE$", lStrKey, , , vbTextCompare)
                lBuffer = Replace(lBuffer, "$MEM_Code$", ls_MEM_Code)
                
                lToAdd(IDX_CM, lIdx) = lBuffer
'task299.3 end
        Next
        
    End If
      
    If Not mDb.ExecuteSQL("BEGIN TRAN Item_DBUpdate") Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DBUpdate", "Requests=", "BEGIN TRAN Item_DBUpdate"
        GoTo Trace_End
    End If
    lTranOpenned = True
    
    If Not mDb.ExecuteSQL(lRequest) Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DBUpdate", "Requests=", lRequest
        GoTo Trace_End
    End If
    
    lCount = UBound(lToDelete, 2)
    Dim lIdxReq As Long, lCountReq As Long
    lCountReq = UBound(lToDelete, 1)
    For lIdx = 0 To lCount
        For lIdxReq = 0 To lCountReq
            If Not mDb.ExecuteSQL(lToDelete(lIdxReq, lIdx)) Then
                If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DBUpdate", "Requests=", lToDelete(lIdxReq, lIdx)
                GoTo Trace_End
            End If
        Next
    Next

    lCount = UBound(lToAdd, 2)
    lCountReq = UBound(lToAdd, 1)
    For lIdx = 0 To lCount
        For lIdxReq = lCountReq To 0 Step -1
            If Not mDb.ExecuteSQL(lToAdd(lIdxReq, lIdx)) Then
                If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DBUpdate", "Requests=", lToAdd(lIdxReq, lIdx)
                GoTo Trace_End
            End If
        Next
    Next
    
    If mDb.SQLRowsAffected = 0 Then
        Call ASC_SendMessage(mDb, mLanguage_Code, 916, "#This data has been updated by another user. Data will be reloaded. Please check the data and try again.")
        GoTo Trace_End
    End If
    
    If Not mDb.ExecuteSQL("COMMIT TRAN Item_DBUpdate") Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DBUpdate", "Requests=", "COMMIT TRAN Item_DBUpdate"
        GoTo Trace_End
    End If
    lTranOpenned = False
    Item_DBUpdate = True
    
Trace_End:
        If lTranOpenned Then
        If Not mDb.ExecuteSQL("ROLLBACK TRAN Item_DBUpdate") Then
            If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DBUpdate", "Requests=", "ROLLBACK TRAN Item_DBUpdate"
            Call ASC_SendMessage(mDb, mLanguage_Code, 891, "#An error occured during this manipulation, please contact your IT support")
            End
        End If
    End If
    Exit Function
    
Err_ItemDBUpdate:
    If lTranOpenned Then
        If Not mDb.ExecuteSQL("ROLLBACK TRAN Item_DBUpdate") Then
            If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:Item_DBUpdate", "Requests=", "ROLLBACK TRAN Item_DBUpdate"
            Call ASC_SendMessage(mDb, mLanguage_Code, 891, "#An error occured during this manipulation, please contact your IT support")
            End
        End If
    End If
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Item_DBUpdate"
  
  
End Function


' Load the labels of a containers
Public Sub LoadLabels(ByRef aControls As Variant, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo Trace_Err

    Dim lIdx As Long, lCount As Long, lLabels As Long
    Dim lControl As Control
    
    lLabels = mDb.OpenSQL("exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'")
    If lLabels = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mDb, "CapSeminar:LoadLabels", "Requests=", "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'"
        GoTo Trace_End
    End If
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON", "OPTIONBUTTON"
                    If lControl.Tag <> "" Then
                        If mDb.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Caption = mDb.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                    End If
                Case "FRAME", "MSFLEXGRID", "TOOLBARCONTROL", "TEXTBOX", "ARMGRID", "COMMANDBUTTON", "ARMCHECKVIEW", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TOOLBR", "SPINBUTTON"
                    ' Do nothing !
                Case Else
                    'debug.print "LoadLabels " & UCase(TypeName(lControl))
            End Select
        Set lControl = Nothing
    Next
    
    mDb.Close (lLabels)

Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":LoadLabels"
          
            
End Sub

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As String = "")

On Error GoTo Trace_Err
   
Dim lc_Control As Control
Dim ls_Charset As String
    
    On Error Resume Next
    If aCodePage = "" Then
    ls_Charset = GetCharSetFromCodePage(GetDefaultConfigCode("Capture_Cfg", "Charset"))
    Else
        ls_Charset = GetCharSetFromCodePage(aCodePage)
    End If
    
    If ls_Charset <> "" Then
        For Each lc_Control In ao_Container
            Select Case UCase(TypeName(lc_Control))
            Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
                  "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
                  "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0"
                lc_Control.Font.Name = "Arial"
                lc_Control.Font.Charset = ls_Charset
            Case "A_SEEK", "A_SRCHTXT"
                lc_Control.Charset = ls_Charset
            End Select
        Next
    End If
    
Trace_End:
    Exit Sub

Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Cap_Seminar:ChangeCharset"
    
End Sub

Private Sub Customer_Add()

On Error GoTo Trace_Err

    Dim lSearchForm As SeekForm
    Dim lSrchTxtForm As SrchTxtForm
    
    Set lSearchForm = New SeekForm
    Load lSearchForm
    Set lSearchForm.ArmDb = mDb
    lSearchForm.TreeView_DateType = "0"
    lSearchForm.ConnectString = mConnectionString
    lSearchForm.Language = mLanguage_Code
    lSearchForm.ComponentType = "CUSTOMER"
    lSearchForm.TreeViewFilters = "" & CH_LDELIMIT & "" & CH_LDELIMIT & "" & CH_LDELIMIT & "''"
    
    Call lSearchForm.Load_A_Com
    
    lSearchForm.show vbModal
    
    Dim lFullData As String, lCustKey As String, lCNTKey As String
    
    If lSearchForm.SelectedData = True Then
        lCustKey = lSearchForm.SelectedItemCode
        lFullData = lSearchForm.SelectedItemFull
    End If
    
    lSearchForm.Unload_A_Com
    
    Unload lSearchForm
    Set lSearchForm = Nothing
    
    If lCustKey = "" Then GoTo Trace_End
    
    
    Set lSrchTxtForm = New SrchTxtForm
    Load lSrchTxtForm
    
    lSrchTxtForm.ConnectString = mConnectionString
    Set lSrchTxtForm.ArmDb = mDb
    lSrchTxtForm.Language = mLanguage_Code
    
    lSrchTxtForm.CodeCustomer = lCustKey
    lSrchTxtForm.CodeContact = ""
    lSrchTxtForm.CodeProject = ""
    lSrchTxtForm.TypeSearch = "Contact"
    lSrchTxtForm.Charset = GetCharSetFromCodePage(GetCodePageFromLanguage(mDb, mLanguage_Code))
   
    lSrchTxtForm.Load_A_Com
   
    lSrchTxtForm.LoadGrid
    lSrchTxtForm.show vbModal

    lCNTKey = lSrchTxtForm.Key1
    lFullData = lFullData & SEP & SEP & lSrchTxtForm.SelectedItemFull
    
    lSrchTxtForm.Unload_A_Com
    Unload lSrchTxtForm
    Set lSrchTxtForm = Nothing

    If lCNTKey = "" Then GoTo Trace_End
    
    If grCustomers.SearchKey(True, Array(lCustKey, lCNTKey)) Then GoTo Trace_End
    Call Customer_LocalAdd(lFullData)
    msrzCustomerToAdd = IIf(Len(msrzCustomerToAdd) <> 0, msrzCustomerToAdd & SEP & SEP, "") & lCustKey & SEP & lCNTKey
    
Trace_End:
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, SCREEN_NAME & ":Customer_Add"
    If Not lSearchForm Is Nothing Then
        Unload lSearchForm
        Set lSearchForm = Nothing
    End If
    If Not lSrchTxtForm Is Nothing Then
        Unload lSrchTxtForm
        Set lSrchTxtForm = Nothing
    End If
    
    
End Sub

    
